// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "EditorReimportHandler.h"
#include "Factories/Factory.h"
#include "GreyscalegorillaMaterialImportFactory.generated.h"

UCLASS(HideCategories = Object)
class UGreyscalegorillaMaterialImportFactory : public UFactory, public FReimportHandler
{
	GENERATED_UCLASS_BODY()

	virtual UObject *FactoryCreateFile(UClass *InClass, UObject *InParent, FName InName, EObjectFlags Flags, const FString &Filename, const TCHAR *Parms, FFeedbackContext *Warn, bool &bOutOperationCanceled) override;

	virtual bool CanReimport(UObject *Obj, TArray<FString> &OutFilenames) override;				   // { return false; }
	virtual void SetReimportPaths(UObject *Obj, const TArray<FString> &NewReimportPaths) override; // { }
	virtual EReimportResult::Type Reimport(UObject *Obj) override;								   // { return EReimportResult::Failed; }
};
